options(na.action=na.exclude)
#
# setwd tells R which folder to use for this script
#

setwd("<your directory or folder path>")

#
# This is an MCMC for a beta-binomial conjugate pair
# The conjugacy is used to illustrate how MCMC yields approximately
# the correct posterior distribution
#
pstore <- c()
alphapri <- 5
betapri <- 1
meanpri <- alphapri / (alphapri + betapri)
sampsize <- 50
y <- 40
phat <- y / sampsize
p0<-0.33
nmcmc <- 2000
for (i in 1:nmcmc) {
  p1 <- min(abs(rnorm(n=1,mean=p0,sd=0.05)),1)#use folded & truncated normal to generate p1
#                                              insures p1 will be in interval (0,1)
  num <- dbeta(x=p1,shape1=alphapri,shape2=betapri)*dbinom(x=y,size=sampsize,prob=p1)
  den <- dbeta(x=p0,shape1=alphapri,shape2=betapri)*dbinom(x=y,size=sampsize,prob=p0)
  rat <- num / den
  uvar <- runif(n=1,min=0,max=1)
  if (rat >= uvar) {
    pstore[i] <- p1
    }
  else {
    pstore[i] <- p0
    }
  p0 <- pstore[i] #change p0 to current value
  }
#
#
#
alphapos <- alphapri + sampsize
betapos <- betapri + sampsize - y
meanpos <- alphapos / (alphapos + betapos)
hist(pstore,main="Histogram of Posterior Sample")
lowlim <- quantile(x=pstore,probs=c(0.025),type=8)
medprob <- quantile(x=pstore,probs=c(0.50),type=8)
upplim <- quantile(x=pstore,probs=c(0.975),type=8)

df2 <- cbind(alphapri,betapri,alphapos,betapos,sampsize,y,lowlim,upplim,pstore)
write.csv(df2,"20190806 beta binomial posterior.csv")    
